/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderRunner;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;

public class BuilderTree
extends BuilderRunner {
    private boolean first = true;

    public BuilderTree(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TREE;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tree and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        this.build();
        this.context.resetCheckCode();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.done("ALLSKY file done");
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        String out = this.context.getOutputPath();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No HiPS tile found");
        }
        this.validateOrder(out);
        this.validateTileSide(out);
        String s = this.loadProperty(out, "dataproduct_subtype");
        if (s != null && s.indexOf("color") >= 0) {
            this.context.setBitpixOrig(0);
            s = this.loadProperty(out, "hips_tile_format");
            this.context.setColor(s);
        }
        try {
            this.context.loadMoc();
        }
        catch (Exception e) {
            new BuilderMoc(this.context).run();
            this.context.info("MOC rebuilt from HiPS tiles");
            this.context.loadMoc();
        }
        this.context.initRegion();
    }

    protected void setConstantes(Fits f) {
        this.first = false;
        if (this.context.isColor()) {
            return;
        }
        this.context.bitpix = this.bitpix = f.bitpix;
        this.context.blank = this.blank = f.blank;
        this.context.bzero = this.bzero = f.bzero;
        this.context.bscale = this.bscale = f.bscale;
        if (this.context.bitpix != 0) {
            this.context.info("Found in first tile: BITPIX=" + this.bitpix + " BLANK=" + this.blank + " BZERO=" + this.bzero + " BSCALE=" + this.bscale);
        } else {
            this.context.info("Colored pixels found in first tile");
        }
    }

    @Override
    public Fits findLeaf(String file) throws Exception {
        Fits f = super.findLeaf(file);
        if (this.first && f != null) {
            this.setConstantes(f);
        }
        return f;
    }

    @Override
    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        long t = System.currentTimeMillis();
        Fits f = this.findLeaf(file);
        long duree = System.currentTimeMillis() - t;
        if (f == null) {
            this.updateStat(0, 0, 1, duree, 0, 0L);
        } else {
            this.updateStat(0, 1, 0, duree, 0, 0L);
        }
        return f;
    }
}

